<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use App\Models\GoogleReview;
use App\Services\GoogleReviewsService;
use Illuminate\Http\Request;

class ReviewController extends Controller
{
    public function show($id)
    {
        try {
            // Get the specific review
            $review = GoogleReview::where('id', $id)
                ->where('is_active', true)
                ->firstOrFail();

            // Get other reviews for sidebar (excluding current review)
            $otherReviews = GoogleReview::where('is_active', true)
                ->where('id', '!=', $id)
                ->latest()
                ->limit(10)
                ->get();

            // Get overall rating and total reviews count
            $googleReviewsService = new GoogleReviewsService();
            $overallRating = $googleReviewsService->getOverallRating();
            $totalReviews = $googleReviewsService->getTotalReviews();

            // Get recent reviews for sidebar
            $recentReviews = GoogleReview::where('is_active', true)
                ->where('id', '!=', $id)
                ->latest()
                ->limit(5)
                ->get();

            return view('frontend.pages.review-detail', compact(
                'review', 
                'otherReviews', 
                'overallRating', 
                'totalReviews',
                'recentReviews'
            ));

        } catch (\Exception $e) {
            abort(404, 'Review not found');
        }
    }
}
