<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\Category;
use App\Models\CbdProduct;
use App\Models\Contact;
use App\Models\Blog;
use App\Models\Product;
use App\Models\Testimonial;
use App\Services\SeoService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\BookCall;
use Illuminate\Support\Facades\Log;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;

class indexController extends Controller
{
    protected $seoService;

    public function __construct(SeoService $seoService)
    {
        $this->seoService = $seoService;
    }

    public function index()
    {
        $this->seoService->setMetaData(
            sys_settings('site_meta_title'),
            sys_settings('site_meta_description'),
            sys_settings('meta_site_keywords'),
            config('app.url')
        );

        $blogs = Blog::latest()
            ->select(['id', 'title', 'slug','blog_image'])
            ->limit(2)
            ->get();


        return view('frontend.index', compact(  'blogs'));
    }

    public function Search(Request $request)
    {
        $this->seoService->setMetaData(
            sys_settings('site_meta_title'),
            sys_settings('site_meta_description'),
            sys_settings('meta_site_keywords'),
            config('app.url')
        );

        if ($request->input('query')) {
            $search = $request->input('query');

            $results = Product::query()
                ->where("product_name", "LIKE", "%{$search}%")->with('media')->get();

            $output = '<ul class="dropdown-menu " style="display: block;position: absolute;left: 0; max-height: 280px;overflow-x: auto;">';
            foreach ($results as $product) {

                $output .= '<li><a href="' . route('page', $product->slug) . '" class="dropdown-item"  style="text-decoration: none; color:#088178;">' . $product->product_name . '</a></li><br>';
            }
            $output .= '</ul>';
            echo $output;

        }
    }

    public function SearchPage(Request $request)
    {
        $search = $request->input('search');

        $products = Product::query()
            ->where("product_name", "LIKE", "%{$search}%")->get();
        return view('frontend.pages.search', compact('products'));
    }





    public function BookCall(Request $request)
    {

        $bookcall = new BookCall();
        $bookcall->name = $request->name;
        $bookcall->email = $request->email;
        $bookcall->phone = $request->phone;
        $bookcall->date = $request->date;
        $bookcall->time = $request->time;
        $bookcall->about = $request->about;
        $bookcall->save();
        return redirect()->back()->with('success', 'You Have Successfully Booked a Call');

    }


}
