<?php

namespace App\Http\Livewire;

use App\Models\Blog;
use App\Models\Category;
use App\Services\GoogleReviewsService;
use App\Services\SeoService;
use Livewire\Component;

class HomePage extends Component
{
    public $blogs,$homepageSubcategories,$productWithCategory,$googleReviews,$overallRating,$totalReviews;

    public function render()
    {
        $seoService = app(SeoService::class);
        $seoService->setMetaData(
            sys_settings('site_meta_title'),
            sys_settings('site_meta_description'),
            sys_settings('meta_site_keywords'),
            config('app.url')
        );

        $this->blogs = Blog::latest()
            ->select(['id', 'title', 'slug','blog_image', 'posted_date'])
            ->limit(2)
            ->get();

        $this->homepageSubcategories = Category::active()
                ->where('homepage_category_banner', 1)
                ->with('media')
                ->select(['id', 'name', 'slug','homepage_category_banner'])
                ->orderBy('name')
                ->get();

        $this->productWithCategory = \Cache::remember('homepage_products_with_category', 3600, function () {
            return Category::active()
                ->where('display_homepage', 1)
                ->select(['categories.id', 'categories.name', 'categories.slug', 'categories.display_homepage'])
                ->with(['products' => function($query) {
                    $query->where('products.display_homepage', 1)
                        ->select([
                            'products.id',
                            'products.product_name',
                            'products.slug',
                            'products.display_homepage'
                        ])
                        ->orderBy('products.created_at', 'desc');
                }, 'media'])
                ->limit(3)
                ->get();
        });

        // Load Google Reviews
        $googleReviewsService = new GoogleReviewsService();
        $this->googleReviews = $googleReviewsService->getReviews(30);
        $this->overallRating = $googleReviewsService->getOverallRating();
        $this->totalReviews = $googleReviewsService->getTotalReviews();

        return view('livewire.home-page');

    }


}
