<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title', 300);
            $table->string('slug', 300);
            $table->string('meta_title', 1501);
            $table->string('meta_keywords', 500)->nullable();
            $table->longText('meta_description')->nullable();
            $table->longText('blog_sdis')->nullable();
            $table->text('blog_ldis')->nullable();
            $table->string('blog_image', 300);
            $table->string('blog_img_title', 300)->nullable();
            $table->boolean('status')->default(true);
            $table->string('author_name')->nullable();
            $table->timestamp('posted_date')->useCurrent();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};

