<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->string('title');
            $table->string('name');
            $table->string('slug');
            $table->text('description')->nullable();
            $table->text('detail')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('faqs')->nullable();
            $table->text('meta_title')->nullable();
            $table->string('category_img')->nullable();
            $table->boolean('status')->default(false);
            $table->boolean('display_homepage')->default(false);
            $table->boolean('homepage_category_banner')->default(false);
            $table->boolean('by_style')->default(false);
            $table->boolean('by_material')->default(false);
            $table->boolean('by_industry')->default(false);
            $table->timestamps();

            $table->foreign('parent_id')->references('id')->on('categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};

