<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email');
            $table->string('phone')->nullable();
            $table->string('flag', 50)->nullable();
            $table->string('length')->nullable();
            $table->string('width')->nullable();
            $table->string('depth')->nullable();
            $table->string('colors')->nullable();
            $table->string('units')->nullable();
            $table->string('quantity');
            $table->string('quantity2')->nullable();
            $table->string('quantity3')->nullable();
            $table->string('stock')->nullable();
            $table->string('box_style')->nullable();
            $table->string('art_desgin')->nullable();
            $table->string('notes')->nullable();
            $table->string('otherproduct')->nullable();
            $table->string('product_image')->nullable();
            $table->string('category')->nullable();
            $table->string('product_name')->nullable();
            $table->string('product_url')->nullable();
            $table->string('product_title')->nullable();
            $table->boolean('order_status')->nullable();
            $table->boolean('conform_order')->default(false);
            $table->boolean('cancel_order')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};

