<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('google_reviews', function (Blueprint $table) {
            $table->id();
            $table->string('reviewer_name', 191);
            $table->string('reviewer_photo', 191)->nullable();
            $table->integer('reviewer_reviews_count')->nullable();
            $table->text('review_text');
            $table->integer('rating');
            $table->dateTime('review_date');
            $table->string('google_review_id', 191)->unique();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('google_reviews');
    }
};

