<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cbd_products', function (Blueprint $table) {
            $table->id();
            $table->string('product_title');
            $table->string('product_name');
            $table->integer('category_id');
            $table->string('slug');
            $table->string('product_front_image');
            $table->string('product_back_image');
            $table->string('product_multiple_images');
            $table->text('product_description');
            $table->text('product_detail');
            $table->string('related_products')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_title')->nullable();
            $table->boolean('status')->default(false);
            $table->boolean('display_homepage')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cbd_products');
    }
};

