@extends('backend.layouts.app')
@section('title')
    Edit Product
@endsection
@push('styles')
    <link href="{{ asset('backend/assets/libs/dropzone/dropzone.css') }}" rel="stylesheet" type="text/css" />

@endpush
@section('contents')
    <form id="editProductForm" action="{{ route('dashboard.product.update', $product) }}" method="POST"
        enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label" for="product-title-input">Product Title (For SEO H1)</label><span
                                class="text-danger">*</span>
                            <input type="text" class="form-control  @error('product_title') is-invalid @enderror"
                                id="product-title-input" name="product_title"
                                value="{{ old('product_title', $product->product_title) }}" placeholder="Enter product title"
                                required>
                            @error('product_title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="product-title-input1">Product Name</label><span
                                class="text-danger">*</span>
                            <input type="text" class="form-control  @error('product_name') is-invalid @enderror"
                                id="product-title-input1" name="product_name"
                                value="{{ old('product_name', $product->product_name) }}" placeholder="Enter product name"
                                required>
                            @error('product_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="slug">Slug</label><span class="text-danger">*</span>
                            <input type="text" class="form-control  @error('slug') is-invalid @enderror" id="slug"
                                name="slug" value="{{ old('slug', $product->slug) }}" placeholder="Product slug" required>
                            @error('slug')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Product Short Description</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-2">Add short description for product</p>
                       <x-text-editor name="product_detail" :value="old('product_detail', $product->product_detail ?? '')" />

                        @error('product_detail')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Product Description</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-2">Add Detailed description for product</p>
                        <x-text-editor name="product_description" :value="old('product_description', $product->product_description ?? '')" height="200px" />
                        @error('product_description')
                        <div class="invalid-feedback">{{$message}}</div>
                        @enderror
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Product Gallery</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <label for="formFile1" class="form-label">Product Front Image</label><span
                                class="text-danger">*</span>
                            <input name="product_front_image"
                                class="form-control  @error('product_front_image') is-invalid @enderror"
                                value="{{ old('product_front_image') }}" type="file" id="formFile1">
                            @error('product_front_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="row">
                                @if ($product->getMedia('product_front_image')->isNotEmpty())
                                    @foreach ($product->getMedia('product_front_image') as $media)
                                        <div class="col-2">
                                            <img src="{{ $media->getUrl('s') }}"
                                                 alt="{{ $media->name }}"
                                                 class="img-thumbnail mt-3 w-100"
                                            />
                                        </div>
                                    @endforeach
                                @endif
                            </div>

                        </div>
                        <div class="mb-4">
                            <label for="formFile2" class="form-label">Product Hover Image</label><span
                                class="text-danger">*</span>
                            <input name="product_back_image"
                                class="form-control  @error('product_back_image') is-invalid @enderror"
                                value="{{ old('product_back_image') }}" type="file" id="formFile2">
                            @error('product_back_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="row">
                                @if ($product->getMedia('product_back_image')->isNotEmpty())
                                    @foreach ($product->getMedia('product_back_image') as $media)
                                        <div class="col-2">
                                            <img src="{{ $media->getUrl('s') }}"
                                                 alt="{{ $media->name }}"
                                                 class="img-thumbnail mt-3 w-100"
                                            />
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <div>
                            <h5 class="fs-14 mb-1">Product Gallery</h5>
                            <p class="text-muted">Add Product Gallery Images <span class="text-danger">*</span></p>
                            <input name="product_multiple_images[]"
                                class=" form-control @error('product_multiple_images[]') is-invalid @enderror"
                                type="file" multiple="multiple">
                            <div class="row">
                            @if ($product->getMedia('product_gallery')->isNotEmpty())
                                @foreach ($product->getMedia('product_gallery') as $media)
                                        <div class="col-2 position-relative">
                                        <img src="{{ $media->getUrl('s') }}"
                                              alt="{{ $media->name }}"
                                             class="img-thumbnail mt-3 w-100"
                                        />
                                         <form action="{{ route('dashboard.product.media.delete', [$product->slug, $media->id]) }}" method="POST" style="display:inline;">
                                                @csrf
                                                <button class="btn btn-danger btn-sm" type="submit" style="position: absolute;right: 10px;top: 15px;">x</button>
                                         </form>
                                       </div>
                                @endforeach
                            @endif
                            </div>

                            @error('product_multiple_images[]')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                <!-- end card -->

                <div class="card">
                    <div class="card-header">
                        General Info
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <div class="form-check form-switch form-switch-custom form-switch-success">
                                        <input class="form-check-input"
                                               {{ $product->display_homepage == 1 ? 'checked' : '' }}
                                                name="display_homepage"
                                               type="checkbox" role="switch" id="display_homepage">
                                        <label class="form-check-label" for="display_homepage">Display on
                                            Homepage</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <div class="form-check form-switch form-switch-custom form-switch-success">
                                        <input class="form-check-input"
                                               {{ $product->by_style == 1 ? 'checked' : '' }}
                                                name="by_style" type="checkbox"
                                               role="switch" id="by_style">
                                        <label class="form-check-label" for="by_style">Box By Style?</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <div class="form-check form-switch form-switch-custom form-switch-success">
                                        <input class="form-check-input"
                                               {{ $product->by_material == 1 ? 'checked' : '' }}
                                               name="by_material" type="checkbox"
                                               role="switch" id="by_material">
                                        <label class="form-check-label" for="by_material">Box By Material?</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <div class="form-check form-switch form-switch-custom form-switch-success">
                                        <input class="form-check-input"
                                               {{ $product->by_industry == 1 ? 'checked' : '' }}
                                                name="by_industry" type="checkbox"
                                               role="switch" id="by_industry">
                                        <label class="form-check-label" for="by_industry">Box By Industry</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="card">
                    <div class="card-header">
                        Meta Data
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label" for="meta-title-input">Meta title</label><span
                                        class="text-danger">*</span>
                                    <input type="text"
                                           class="form-control @error('meta_title') is-invalid @enderror"
                                           name="meta_title" value="{{ old('meta_title', $product->meta_title) }}"
                                           placeholder="Enter meta title" id="meta-title-input">
                                    @error('meta_title')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label" for="meta-keywords-input">Meta Keywords</label>
                                    <input type="text" class="form-control" name="meta_keywords"
                                           value="{{ old('meta_keywords', $product->meta_keywords) }}"
                                           placeholder="Enter meta keywords" id="meta-keywords-input">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <label class="form-label" for="meta-description-input">Meta Description</label><span
                                    class="text-danger">*</span>
                                <textarea class="form-control @error('meta_description') is-invalid @enderror" id="meta-description-input"
                                          name="meta_description" placeholder="Enter meta description" rows="3">{{ old('meta_description', $product->meta_description) }}</textarea>
                                @error('meta_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Client Stories</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 mb-3">
                                <div id="clientStoryRepeater">
                                    @if($product->client_story)
                                        @foreach(json_decode($product->client_story, true) as $key => $story)
                                            <div class="border-bottom-dashed mb-3">
                                                <p class="text-primary">Client Story: {{$key}}</p>
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <label for="client-story-image-{{$key}}" class="form-label">Image</label>
                                                        <input class="form-control" type="file" name="client_story[{{$key}}][image]" id="client-story-image-{{$key}}" accept="image/*" />
                                                        @if(isset($story['image']) && $story['image'])
                                                            <div class="mt-2">
                                                                <img src="{{ asset('storage/' . $story['image']) }}" alt="Client Story Image" class="img-thumbnail" style="max-width: 200px;">
                                                                <p class="small text-muted">Current image (upload new to replace)</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-12 mt-2">
                                                        <label for="client-story-description-{{$key}}" class="form-label">Description</label>
                                                        <x-text-editor name="client_story[{{$key}}][description]" :value="$story['description'] ?? ''" height="150px" />
                                                    </div>
                                                    @if($key != 1)
                                                        <div class="col-md-2 mt-2">
                                                            <a href="javascript:void(0);" onclick="removeClientStoryRow(this)" class="btn btn-danger mt-4" title="Remove"> Remove</a>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="border-bottom-dashed mb-3">
                                            <p class="text-primary">Client Story: 1</p>
                                            <div class="row mb-3">
                                                <div class="col-md-12">
                                                    <label for="client-story-image-1" class="form-label">Image</label>
                                                    <input class="form-control" type="file" name="client_story[1][image]" id="client-story-image-1" accept="image/*" />
                                                </div>
                                                <div class="col-md-12 mt-2">
                                                    <label for="client-story-description-1" class="form-label">Description</label>
                                                    <x-text-editor name="client_story[1][description]" :value="''" height="150px" />
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <a href="javascript:void(0);" id="addClientStoryButton" class="btn btn-success mt-3" title="Add field"> Add Client Story</a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Product FAQs</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 mb-3">
                                <div id="formRepeater">
                                    @if($product->faqs)
                                    @foreach(json_decode($product->faqs, true) as $key => $faq)
                                            <div class="border-bottom-dashed mb-3">
                                                <p class="text-primary">FAQ: {{$key}}</p>
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <label for="question-{{$key}}" class="form-label">Question</label>
                                                        <input class="form-control" type="text" name="faqs[{{$key}}][question]" id="question-{{$key}}" placeholder="Question" value="{{ $faq['question'] }}" />
                                                    </div>
                                                    <div class="col-md-12 mt-2">
                                                        <label for="answer-{{$key}}" class="form-label">Answer</label>
                                                        <input class="form-control" type="text" name="faqs[{{$key}}][answer]" id="answer-{{$key}}" placeholder="Answer" value="{{ $faq['answer'] }}" />
                                                    </div>
                                                    @if($key!== 1)
                                                        <div class="col-md-2 mt-2">
                                                            <a href="javascript:void(0);" onclick="removeRow({{$key}})" id="removeButton-{{$key}}"
                                                               class="  btn btn-danger mt-4" title="Add field"> Remove</a>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <a href="javascript:void(0);" id="addButton" class="btn btn-success mt-3" title="Add field"> Add FAQ</a>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="text-end mb-3">
                    <button type="submit" class="btn rounded-pill btn-primary waves-effect waves-light">Update</button>
                </div>


            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Publish</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="choices-publish-status-input" class="form-label">Status</label>
                            <select class="form-select" name="status" id="choices-publish-status-input" data-choices
                                data-choices-search-false>
                                <option value="1" {{ $product->status == 1 ? 'selected' : '' }}>Enable</option>
                                <option value="0" {{ $product->status == 0 ? 'selected' : '' }}>Disable</option>
                            </select>
                        </div>
                    </div>
                    <!-- end card body -->
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Product Categories<span class="text-danger">*</span></h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-2"> <a href="{{ route('dashboard.category.create') }}" target="_blank"
                                class="float-end text-decoration-underline">Add
                                New</a>Select product category</p>
                        <select class="js-example-basic-multiple @error('product_category_id[]') is-invalid @enderror"
                            name="product_category_id[]" id="product_category_id" multiple="multiple">
                            @foreach ($categories as $category)
                                @foreach ($category->categories as $subcate)
                                    <option value="{{ $subcate->id }}"
                                        {{ in_array($subcate->id, $product->category()->pluck('id')->toArray()) == true ? 'selected' : '' }}>
                                        {{ $subcate->title }}
                                    </option>
                                @endforeach
                            @endforeach
                        </select>
                        @error('product_category_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Related Product</h5>
                    </div>
                    <div class="card-body">
                        <select class="js-example-basic-multiple @error('related_products[]') is-invalid @enderror"
                            multiple="multiple" name="related_products[]" id="related_products">
                            @foreach ($products as $productItem)
                                <option value="{{ $productItem->id }}"
                                    {{ in_array($productItem->id, $related_products) == true ? 'selected' : '' }}>
                                    {{ $productItem->product_name }}</option>
                            @endforeach
                        </select>
                        @error('related_products')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>


            </div>
        </div>
    </form>
@endsection
@push('scripts')
    <!-- ckeditor -->
    {{-- <script src="{{ asset('backend/assets/libs/@ckeditor/ckeditor5-build-classic/build/ckeditor.js') }}"></script> --}}

    <!-- dropzone js -->
    <script src="{{ asset('backend/assets/libs/dropzone/dropzone-min.js') }}"></script>

    <script src="{{ asset('backend/assets/js/pages/ecommerce-product-create.init.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#product_category_id').select2({
                placeholder: "Select categories",
                allowClear: true,
                multiple: true,
            });
            $('#related_products').select2({
                placeholder: "Select Related products",
                allowClear: true,
                multiple: true,
            });
        });


    </script>


    <script>
        @php
            $faqs = json_decode($product->faqs, true);
            $repeaterCount = is_array($faqs) ? count($faqs) : 1;
        @endphp
        //repeated form
        let repeaterCount = {{$repeaterCount}};
        const formRepeater = document.getElementById('formRepeater');
        const addButton = document.getElementById('addButton');

        addButton.addEventListener('click', () => {
            repeaterCount++;
            const newRow = document.createElement('div');
            newRow.classList.add('border-bottom-dashed', 'mb-3');
            newRow.innerHTML = `
        <p class="text-primary">FAQ: ${repeaterCount}</p>
        <div class="row mb-3">
            <div class="col-md-12">
                <label for="question-${repeaterCount}" class="form-label">Question</label>
                <input class="form-control" type="text" name="faqs[${repeaterCount}][question]" id="question-${repeaterCount}" placeholder="Question" />
            </div>
            <div class="col-md-12 mt-2">
                <label for="answer-${repeaterCount}" class="form-label">Answer</label>
                <input class="form-control" type="text" name="faqs[${repeaterCount}][answer]" id="answer-${repeaterCount}" placeholder="Answer" />
            </div>
         <div class="col-md-4">
        <a href="javascript:void(0);" onclick="removeRow(${repeaterCount})" id="removeButton-${repeaterCount}"
           class="  btn btn-danger mt-4" title="Add field"> Remove</a>
    </div>
        </div>
    `;
            formRepeater.appendChild(newRow);
        });

        function removeRow(repeaterCount) {
            if (repeaterCount > 0) {
                if (confirm('Are you sure you want to delete this element?')) {
                    formRepeater.removeChild(formRepeater.lastElementChild);
                    repeaterCount--;
                }
            }
        }

    </script>
    <script>
        // Client Story Repeater
        @php
            $clientStories = json_decode($product->client_story, true);
            $clientStoryCount = is_array($clientStories) ? count($clientStories) : 1;
        @endphp
        let clientStoryCount = {{$clientStoryCount}};
        const clientStoryRepeater = document.getElementById('clientStoryRepeater');
        const addClientStoryButton = document.getElementById('addClientStoryButton');

        // Function to get next available client story number
        function getNextClientStoryNumber() {
            const existingNumbers = [];

            // Get all existing story numbers from the DOM
            const storyElements = clientStoryRepeater.querySelectorAll('.text-primary');
            storyElements.forEach(element => {
                const match = element.textContent.match(/Client Story: (\d+)/);
                if (match) {
                    existingNumbers.push(parseInt(match[1]));
                }
            });

            // Sort the numbers to find gaps
            existingNumbers.sort((a, b) => a - b);

            // Find the first gap or return the next sequential number
            for (let i = 1; i <= existingNumbers.length + 1; i++) {
                if (!existingNumbers.includes(i)) {
                    return i;
                }
            }

            return existingNumbers.length + 1;
        }

        addClientStoryButton.addEventListener('click', () => {
            const nextNumber = getNextClientStoryNumber();
            addClientStoryRow(nextNumber);
        });

        function addClientStoryRow(count, description = '') {
            const editorId = `client-story-description-${count}`;
            const newRow = document.createElement('div');
            newRow.classList.add('border-bottom-dashed', 'mb-3');
            newRow.innerHTML = `
                <p class="text-primary">Client Story: ${count}</p>
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="client-story-image-${count}" class="form-label">Image</label>
                        <input class="form-control" type="file" name="client_story[${count}][image]" id="client-story-image-${count}" accept="image/*" />
                    </div>
                    <div class="col-md-12 mt-2">
                        <label for="${editorId}" class="form-label">Description</label>
                        <textarea name="client_story[${count}][description]" id="${editorId}" style="min-height: 150px;">${description}</textarea>
                    </div>
                    <div class="col-md-4">
                        <a href="javascript:void(0);" onclick="removeClientStoryRow(this)" class="btn btn-danger mt-4" title="Remove"> Remove</a>
                    </div>
                </div>
            `;
            clientStoryRepeater.appendChild(newRow);

            // Initialize CKEditor for the new textarea
            setTimeout(function() {
                if (typeof CKEDITOR !== 'undefined') {
                    // Destroy existing instance if present
                    if (CKEDITOR.instances[editorId]) {
                        try {
                            CKEDITOR.instances[editorId].destroy(true);
                        } catch (e) {}
                    }

                    // Create new CKEditor instance
                    var editor = CKEDITOR.replace(editorId, {
                        height: 150,
                        filebrowserUploadUrl: "{{ route('editor.image.upload') }}?_token={{ csrf_token() }}",
                        filebrowserImageUploadUrl: "{{ route('editor.image.upload') }}?_token={{ csrf_token() }}",
                        filebrowserUploadMethod: 'form'
                    });

                    // Handle form submission
                    var textarea = document.getElementById(editorId);
                    var form = textarea ? textarea.closest('form') : null;
                    if (form && !form.hasAttribute('data-ckeditor-handled-' + editorId)) {
                        form.setAttribute('data-ckeditor-handled-' + editorId, 'true');
                        form.addEventListener('submit', function() {
                            if (editor) {
                                editor.updateElement();
                            }
                        });
                    }
                }
            }, 100);
        }

        function removeClientStoryRow(button) {
            if (confirm('Are you sure you want to delete this client story?')) {
                const row = button.closest('.border-bottom-dashed');

                // Find and destroy CKEditor instance before removing the row
                const textarea = row.querySelector('textarea[id^="client-story-description-"]');
                if (textarea && textarea.id && CKEDITOR.instances[textarea.id]) {
                    try {
                        CKEDITOR.instances[textarea.id].destroy(true);
                    } catch (e) {
                        console.warn('Error destroying CKEditor instance:', e);
                    }
                }

                clientStoryRepeater.removeChild(row);
            }
        }
    </script>
@endpush
