@extends('frontend.layouts.app')
@section('title')
All Boxes
@endsection
@section('content')
    <div class="page-header breadcrumb-wrap">
        <div class="container">
            <div class="breadcrumb">
                {!! $AllProductBreadcrumb !!}
            </div>
        </div>
    </div>
    <section class="mt-50 mb-50">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="shop-product-fillter">
                        <div class="totall-product">
                            <p> We found <strong class="text-brand">{{$products->count()}}</strong> items for you!</p>
                        </div>
                    </div>
                    <div class="row product-grid-3">
                        @foreach($products as $product)
                        <div class="col-lg-3 col-md-4">
                            <div class="product-cart-wrap mb-30">
                                <div class="product-img-action-wrap">
                                    <div class="product-img product-img-zoom">
                                        <a title="Action link for {{$product->product_name}} detail page" href="{{route('page',$product->slug)}}">
                                            @if ($product->getMedia('product_front_image')->isNotEmpty())
                                                @foreach($product->getMedia('product_front_image') as $media)
                                                    <img title="{{$product->product_name}}" class="default-img" src="{{ route('media.show', [$media->id, 'l', $media->file_name]) }}" alt="{{ $media->name }}">
                                                @endforeach
                                            @endif
                                        </a>
                                    </div>

                                </div>
                                <div class="product-content-wrap">
                                    <div class="product-category">
                                       Box By Industry
                                    </div>
                                    <span><a title="Action link for {{$product->product_name}} detail page"  href="{{route('page',$product->slug)}}">{{$product->product_name}}</a></span>

                                    <div class="product-action-1 show">
                                        <a title="Action link for {{$product->product_name}} detail page"  aria-label="Check Categories" class="action-btn hover-up" href="{{route('page',$product->slug)}}"><i class="fi-rs-shopping-bag-add"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <!--pagination-->
{{--                    <div class="pagination-area mt-15 mb-sm-5 mb-lg-0">--}}
{{--                        <nav aria-label="Page navigation example">--}}
{{--                            <ul class="pagination justify-content-start">--}}
{{--                                <li class="page-item active"><a class="page-link" href="#">01</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#">02</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#">03</a></li>--}}
{{--                                <li class="page-item"><a class="page-link dot" href="#">...</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#">16</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#"><i class="fi-rs-angle-double-small-right"></i></a></li>--}}
{{--                            </ul>--}}
{{--                        </nav>--}}
{{--                    </div>--}}
                </div>
            </div>
        </div>
    </section>

@endsection
