{{--resources/views/livewire/pages/subcategory-to-products.blade.php--}}
<div>
    <div class="page-header breadcrumb-wrap">
        <div class="container">
            <div class="breadcrumb">
                {!! $breadcrumbData !!}
            </div>
        </div>
    </div>

    <section class="mt-50 mb-50">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="shop-product-fillter">
                        <h1 class="text-center" style="font-size: 28px!important;">{{$subCategoryToProducts->title}}</h1>
                        <div class="totall-product">
                            <p> We found <strong class="text-brand">{{$subCategoryToProducts->products->count()}}</strong> items for you!</p>
                        </div>
                    </div>
                    <div class="infinite-scroll">
                        <div class="row product-grid-3">
                            @foreach($subCategoryToProducts->products as $product)
                                <div class="col-lg-3 col-md-4">
                                    <div class="product-cart-wrap mb-30">
                                        <div class="product-img-action-wrap">
                                            <div class="product-img product-img-zoom">
                                                <a title="Action link for {{$product->product_name}} detail page" href="{{route('page',$product->slug)}}">
                                                    @if ($product->getMedia('product_front_image')->isNotEmpty())
                                                        @foreach($product->getMedia('product_front_image') as $media)
                                                            <img title="{{$product->product_title}}"
                                                                 class="hover-img"
                                                                 src="{{ $media->getUrl('l') }}"
                                                                 alt="{{ $media->name }}">
                                                        @endforeach
                                                    @endif
                                                    @if ($product->getMedia('product_back_image')->isNotEmpty())
                                                        @foreach($product->getMedia('product_back_image') as $media)
                                                            <img title="{{$product->product_title}}"
                                                                 class="default-img"
                                                                 src="{{ $media->getUrl('l') }}"
                                                                 alt="{{ $media->name }}">
                                                        @endforeach
                                                    @endif
                                                </a>
                                            </div>
                                        </div>
                                        <div class="product-content-wrap">
                                            <div class="product-category">
                                                <a title="Action link for {{$subCategoryToProducts->product_name}} category page"
                                                   href="{{route('page',$subCategoryToProducts->slug)}}">
                                                    {{$subCategoryToProducts->name}}
                                                </a>
                                            </div>
                                            <span>
            <a title="Action link for {{$product->product_name}} detail page"
               href="{{route('page',$product->slug)}}">
                {{$product->product_name}}
            </a>
        </span>

                                            <div class="product-action-1 show">
                                                <a title="Action link for {{$product->product_name}} detail page"
                                                   aria-label="See Product Detail"
                                                   class="action-btn hover-up"
                                                   href="{{route('page',$product->slug)}}">
                                                    <i class="fi-rs-shopping-bag-add"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

   

    <x-specification-tabs
        :description="$subCategoryToProducts->detail"
        :faq-data="$subCategoryToProducts?->faqs "
    />

    @section('schema')
        {!! $schemaData['webpage'] !!}
        {!! $schemaData['breadcrumb'] !!}
        {!! $schemaData['itemList'] !!}
    @endsection
</div>
