<!-- ========== App Menu ========== -->
<div class="app-menu navbar-menu">
    <!-- LOGO -->
    <div class="navbar-brand-box">
        <!-- Dark Logo-->
        <a href="" class="logo logo-dark">
            <span class="logo-sm">
                <img src="<?php echo e(asset('logo.svg')); ?>" alt="" height="30">
            </span>
            <span class="logo-lg">
                <img src="<?php echo e(asset('logo.svg')); ?>" alt="" height="50">
            </span>
        </a>
        <!-- Light Logo-->
        <a href="" class="logo logo-light">
            <span class="logo-sm">
                <img src="<?php echo e(asset('logo.svg')); ?>" alt="" height="30">
            </span>
            <span class="logo-lg">
                <img src="<?php echo e(asset('logo.svg')); ?>" alt="" height="50">
            </span>
        </a>
        <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
            <i class="ri-record-circle-line"></i>
        </button>
    </div>

    <div id="scrollbar">
        <div class="container-fluid">

            <div id="two-column-menu">
            </div>
            <ul class="navbar-nav" id="navbar-nav">
                <li class="menu-title"><span data-key="t-menu">Menu</span></li>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-users')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.user.*') || request()->routeIs('dashboard.role.*') || request()->routeIs('dashboard.permission.*') ? 'active':''); ?>" href="#userManagement" data-bs-toggle="collapse" role="button" aria-expanded="<?php echo e(request()->routeIs('dashboard.user.*') || request()->routeIs('dashboard.role.*') || request()->routeIs('dashboard.permission.*') ? 'true':'false'); ?>" aria-controls="userManagement">
                        <i class="ri-user-settings-line"></i> <span data-key="t-dashboards">User Management</span>
                    </a>
                    <div class="collapse <?php echo e(request()->routeIs('dashboard.user.*') || request()->routeIs('dashboard.role.*') || request()->routeIs('dashboard.permission.*') ? 'show':''); ?> menu-dropdown" id="userManagement">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="<?php echo e(route('dashboard.user.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.user.*') ? 'active': ''); ?>" data-key="t-analytics">Users</a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('dashboard.role.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.role.*') ? 'active': ''); ?>" data-key="t-analytics">Roles</a>
                            </li>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-permissions')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('dashboard.permission.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.permission.*') ? 'active': ''); ?>" data-key="t-analytics">Permissions</a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-marketing')): ?>
                <li class="nav-item ">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.marketing-contact.*') || request()->routeIs('dashboard.campaign.*') || request()->routeIs('dashboard.campaign.sms.campaign') ? 'active':''); ?>" href="#sidebarDashboards" data-bs-toggle="collapse" role="button" aria-expanded="<?php echo e(request()->routeIs('dashboard.marketing-contact.index') || request()->routeIs('dashboard.campaign.index') || request()->routeIs('dashboard.campaign.sms.campaign') ? 'true':'false'); ?>" aria-controls="sidebarDashboards">
                        <i class="ri-dashboard-2-line"></i> <span data-key="t-dashboards">Marketing</span>
                    </a>
                    <div class="collapse <?php echo e(request()->routeIs('dashboard.marketing-contact.*') || request()->routeIs('dashboard.campaign.*') || request()->routeIs('dashboard.campaign.sms.campaign') ? 'show':''); ?> menu-dropdown" id="sidebarDashboards">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item ">
                                <a href="<?php echo e(route('dashboard.marketing-contact.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.marketing-contact.*')  ? 'active': ''); ?>" data-key="t-analytics">Marketing Contacts</a>
                            </li>
                            <li class="nav-item ">
                                <a href="<?php echo e(route('dashboard.campaign.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.campaign.*') ? 'active': ''); ?>" data-key="t-analytics">Campaign</a>
                            </li>
                            <li class="nav-item ">
                                <a href="<?php echo e(route('dashboard.campaign.sms.campaign')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.campaign.sms.campaign')  ? 'active': ''); ?>" data-key="t-analytics">SMS Campaign</a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-products')): ?>
                <li class="nav-item ">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.category.*') || request()->routeIs('dashboard.product.*')); ?>" href="#productManagement" data-bs-toggle="collapse" role="button" aria-expanded="<?php echo e(request()->routeIs('dashboard.category.index') || request()->routeIs('dashboard.product.index')  ? 'true':'false'); ?>" aria-controls="productManagement">
                        <i class="ri-gift-2-line"></i> <span data-key="t-dashboards">Product Management</span>
                    </a>
                    <div class="collapse <?php echo e(request()->routeIs('dashboard.category.*') || request()->routeIs('dashboard.product.*')  ? 'show':''); ?> menu-dropdown" id="productManagement">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item ">
                                <a href="<?php echo e(route('dashboard.category.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.category.index')  ? 'active': ''); ?>" data-key="t-analytics">Category</a>
                            </li>
                            <li class="nav-item ">
                                <a href="<?php echo e(route('dashboard.product.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.product.*') ? 'active': ''); ?>" data-key="t-analytics">Products</a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-banners')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.banner.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.banner.index')); ?>">
                        <i class="ri-honour-line"></i> <span data-key="t-widgets">Banners</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-blogs')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.blog.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.blog.index')); ?>">
                        <i class="ri-book-2-line"></i> <span data-key="t-widgets">Blogs</span>
                    </a>
                </li>
                <?php endif; ?>





                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-queries')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.query.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.query.index')); ?>">
                        <i class="ri-customer-service-2-line"></i> <span data-key="t-widgets">Queries</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-settings')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.setting.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.setting.index')); ?>">
                        <i class="ri-honour-line"></i> <span data-key="t-widgets">Settings</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-reviews')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.google-reviews.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.google-reviews.index')); ?>">
                        <i class="ri-star-line"></i> <span data-key="t-widgets">Google Reviews (API)</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.google-reviews.manual-import')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.google-reviews.manual-import')); ?>">
                        <i class="ri-upload-line"></i> <span data-key="t-widgets">Manual Import Reviews</span>
                    </a>
                </li>
                <?php endif; ?>

                <!-- <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.google-reviews-scraper.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.google-reviews-scraper.index')); ?>">
                        <i class="ri-scissors-line"></i> <span data-key="t-widgets">Reviews Scraper (Free)</span>
                    </a>
                </li> -->


                <!-- <li class="nav-item">
                    <a class="nav-link menu-link <?php echo e(request()->routeIs('dashboard.google-maps-data.*')  ? 'active': ''); ?>" href="<?php echo e(route('dashboard.google-maps-data.debugger')); ?>">
                        <i class="ri-bug-line"></i> <span data-key="t-widgets">Google Maps Debugger</span>
                    </a>
                </li> -->

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('generate-sitemap')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link" target="_blank" href="<?php echo e(route('sitemap.xml')); ?>">
                        <i class="ri-honour-line"></i> <span data-key="t-widgets">Generate Sitemap</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clear-cache')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link" target="_blank" href="<?php echo e(route('optimize.clear')); ?>">
                        <i class="ri-honour-line"></i> <span data-key="t-widgets">Clear Website Cache</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pull-code')): ?>
                <li class="nav-item">
                    <a class="nav-link menu-link" target="_blank" href="<?php echo e(route('git.pull')); ?>">
                        <i class="ri-honour-line"></i> <span data-key="t-widgets">Pull latest Code</span>
                    </a>
                </li>
                <?php endif; ?>

            </ul>
        </div>
        <!-- Sidebar -->
    </div>

    <div class="sidebar-background"></div>
</div>
<!-- Left Sidebar End -->
<!-- Vertical Overlay-->
<div class="vertical-overlay"></div>
<?php /**PATH /Users/rizwanashraf/Desktop/www/packaging-solutions/resources/views/backend/partials/sidebar.blade.php ENDPATH**/ ?>